<?php
header('Content-Type: application/json');

$mobile = $_GET['num'] ?? '';
$otp = $_GET['otp'] ?? '';

if (empty($mobile) || empty($otp)) {
    echo json_encode(['status' => 'false', 'message' => 'Missing parameters']);
    exit;
}

$url = "https://api.pagarbook.com/auth/phone/otp/verify";
$data = [
    "phone" => $mobile,
    "otp" => $otp
];

$headers = [
    "Content-Type: application/json",
    "User-Agent: Mozilla/5.0 (Linux; Android 12; V2205 Build/SP1A.210812.003_IN) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.7049.111 Mobile Safari/537.36",
    "clientplatform: WEB",
    "userrole: EMPLOYER",
    "clientbuildnumber: 5272",
    "appversioncode: 5272",
    "Origin: https://web.pagarbook.com",
    "Referer: https://web.pagarbook.com/",
    "X-Requested-With: mark.via.gp",
    "sec-ch-ua-platform: \"Android\"",
    "sec-ch-ua: \"Android WebView\";v=\"135\", \"Not-A.Brand\";v=\"8\", \"Chromium\";v=\"135\"",
    "sec-ch-ua-mobile: ?1"
];

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $url,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($data),
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => $headers,
    CURLOPT_SSL_VERIFYPEER => false
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

$json = json_decode($response, true) ?? [];

// Check if token exists in the response (indicating successful verification)
if (isset($json['token']) && !empty($json['token'])) {
    echo '{"status": "true", "message": "OTP Verified"}';
} else {
    // Return original error response if verification failed
    echo $response ?: json_encode(['status' => 'false', 'message' => 'Request failed']);
}
?>